<?php
/**
 * Tags
 *
 * @package     AutomatorWP\Integrations\AffiliateWP\Tags
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Referral tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_affiliatewp_referral_tags() {

    $referral_tags = array(
        'affiliatewp_referral_id' => array(
            'label'     => __( 'Referral ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '123',
        ),
        'affiliatewp_referral_amount' => array(
            'label'     => __( 'Referral amount', 'automatorwp-pro' ),
            'type'      => 'float',
            'preview'   => '123.45',
        ),
        'affiliatewp_referral_currency' => array(
            'label'     => __( 'Referral currency', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'USD',
        ),
        'affiliatewp_referral_currency_sign' => array(
            'label'     => __( 'Referral currency sign', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '$',
        ),
        'affiliatewp_referral_amount_formatted' => array(
            'label'     => __( 'Referral amount formatted', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '$123.45',
        ),
        'affiliatewp_referral_campaign' => array(
            'label'     => __( 'Referral campaign', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => __( 'My-Campaign', 'automatorwp-pro' ),
        ),
        'affiliatewp_referral_reference' => array(
            'label'     => __( 'Referral reference', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '0123',
        ),
    );

    /**
     * Filter referral tags
     *
     * @since 1.0.0
     *
     * @param array $tags
     *
     * @return array
     */
    return apply_filters( 'automatorwp_affiliatewp_referral_tags', $referral_tags );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_affiliatewp_get_trigger_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {

    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Bail if no order ID attached
    if( ! $trigger_args ) {
        return $replacement;
    }

    // Bail if trigger is not from this integration
    if( $trigger_args['integration'] !== 'affiliatewp' ) {
        return $replacement;
    }

    $tags = array_keys( automatorwp_affiliatewp_referral_tags() );

    // Bail if not order tags found
    if( ! in_array( $tag_name, $tags ) ) {
        return $replacement;
    }

    $referral_id = (int) automatorwp_get_log_meta( $log->id, 'referral_id', true );

    // Bail if no referral ID attached
    if( $referral_id === 0 ) {
        return $replacement;
    }

    $referral = affwp_get_referral( $referral_id );

    // Bail if referral can't be found
    if( ! $referral ) {
        return $replacement;
    }

    // Format values for some tags
    switch( $tag_name ) {
        case 'affiliatewp_referral_id':
            $replacement = $referral->referral_id;
            break;
        case 'affiliatewp_referral_amount':
            $replacement = $referral->amount;
            break;
        case 'affiliatewp_referral_currency':
            $replacement = $referral->currency;
            break;
        case 'affiliatewp_referral_currency_sign':
            $replacement = affwp_currency_filter( '' );
            break;
        case 'affiliatewp_referral_amount_formatted':
            $replacement = affwp_currency_filter( affwp_format_amount( $referral->amount ) );
            break;
        case 'affiliatewp_referral_campaign':
            $replacement = $referral->campaign;
            break;
        case 'affiliatewp_referral_reference':
            $replacement = $referral->reference;
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_affiliatewp_get_trigger_tag_replacement', 10, 6 );